﻿#include  "StdAfx.h"

#include  <szArchiveContent.hpp>
#include  <szStoredItem.hpp>
#include  <szStoredItemContainer.hpp>
#include  <szPath.hpp>

SZ_AN_BEG

typedef boost::ptr_vector<szpp::StoredItem> ptr_vec;

SZ_AN_END

SZ_NS_BEG(szpp)

ArchiveContent::ArchiveContent() : root(), items(), archiveProperty()
{
}

ArchiveContent::~ArchiveContent()
{
  // ルートコンテナは auto_ptr、格納アイテムリストは ptr_vector なので自動的に解放される
}

void ArchiveContent::AddItem(StoredItem *item)
{
  items.push_back(item);
}

void ArchiveContent::ConstructTree(const szstring &rootName)
{
  // どんな場合でもルート要素は必要となるため要素名を空文字列にして作成
  root.reset(new StoredItemContainer(rootName));
  
  for (ptr_vec::size_type i = 0; i < items.size(); ++i)
  {
    StoredItem *item = &items[i];

    // パス名から末尾のセパレータを除き、ディレクトリ要素ごとに分解
    szstring path = item->GetName();
    TrimSeparator(&path);
    if (path.empty())
      path.assign(rootName); // 古い tgz では *.tar のファイル名を含んでいないことがあるので、ルート名をコピー
    item->SetName(path);

    std::deque<szstring> d = Decompose(path);

    assert(!d.empty());

    StoredItemContainer * container = root.get();
    while (d.size() > 1)
    {
      // リーフ要素ではないので、論理的に top はフォルダ要素となる
      const szstring &top = d.front();
      StoredItemContainer *matchingContainer = container->FindSubContainer(top);
      if (0 == matchingContainer)
      {
        // 対応するコンテナがないので登録する
        matchingContainer = new StoredItemContainer(top);
        container->AddSubContainer(matchingContainer);
        matchingContainer->SetParent(container);
      }
      container = matchingContainer;
      d.pop_front();
    }
    
    // リーフ要素を追加
    if (!item->GetFileAttributes().IsDirectory())
    {
      // リーフ要素はディレクトリ以外
      //
      // 文字ケースだけが異なるフォルダが既にある場合の改名処理などを実装？
      container->AddSubItem(item);
    }
    else
    {
      // リーフ要素がディレクトリで、既にコンテナは作られているというケースも、理屈的には可能なので、親コンテナのサブコンテナを検索。
      // ex. "/usr/bin/perl.exe" の次に "/usr/bin" が出現したら、/usr/bin に対応するコンテナは既に作られていることになる。
      StoredItemContainer *leafContainer = container->FindSubContainer(d.back());
      if (0 == leafContainer)
      {
        leafContainer = new StoredItemContainer(d.back());
        container->AddSubContainer(leafContainer);
        leafContainer->SetParent(container);
      }
      leafContainer->SetItem(item);
    }
    item->SetParent(container);
  }
}

SZ_NS_END(szpp)
